/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class ExtremeFreezingModifier
extends Modifier
implements MeleeHitModifierHook,
InventoryTickModifierHook,
ProjectileHitModifierHook {
    public static boolean checkFreeze(Player player) {
        return player.f_19797_ % 80 == 0;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT);
    }

    public static void freeze(LivingEntity center, int level) {
        float range = 5 + 3 * level;
        List ens = center.f_19853_.m_45976_(Mob.class, new AABB(center.m_20185_() - (double)range, center.m_20186_() - (double)range, center.m_20189_() - (double)range, center.m_20185_() + (double)range, center.m_20186_() + (double)range, center.m_20189_() + (double)range));
        if (!ens.isEmpty()) {
            for (Mob en : ens) {
                if (en == null) continue;
                Mob enlb = en;
                enlb.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
                enlb.m_146917_(85);
            }
        }
    }

    public static boolean checkParticle(Player player) {
        return player.f_19797_ % 4 == 0;
    }

    public static void particle(LivingEntity entity) {
        entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_() + RANDOM.nextDouble() - 0.5, entity.m_20186_() + RANDOM.nextDouble(), entity.m_20189_() + RANDOM.nextDouble() - 0.5, 0.0, 0.25, 0.0);
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (isSelected) {
            if (ExtremeFreezingModifier.checkFreeze((Player)holder)) {
                ExtremeFreezingModifier.freeze(holder, modifier.getLevel());
            }
            if (ExtremeFreezingModifier.checkParticle((Player)holder)) {
                ExtremeFreezingModifier.particle(holder);
            }
        }
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && !target.m_20193_().f_46443_ && target.m_6084_()) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
            target.m_146917_(target.m_146891_() + 40 * modifier.getLevel());
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null && !target.m_20193_().f_46443_ && target.m_6084_()) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
            target.m_146917_(target.m_146891_() + 40 * modifier.getLevel());
        }
        return false;
    }
}

